import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.TModelKey;
import java.security.Security;
import java.util.Vector;

public class UDDIDeleteBinding1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		TModelList tl = proxy.find_tModel("servicesweb-compagnie-com:inquiry", null, null, null, 0 );

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		System.out.println(tis.size()+" tmodel(s) found\n");
		TModelInfo ti = null;
		Vector tiv = tis.getTModelInfoVector();
		for (int i = 0; i < tiv.size(); i++) {
			ti = (TModelInfo)tiv.elementAt(i);
			System.out.println(ti.getNameString());
			System.out.println(ti.getTModelKey());
			System.out.println("\n");
		}

		Vector names = new Vector();
		names.add(new Name("Mon API de recherche UDDI"));
		ServiceList sl = proxy.find_service(null, names, null, null, null, 0);

		ServiceInfos sis = sl.getServiceInfos();
		if (sis.size() == 0) {
			System.out.println("no service(s) found");
			System.exit(0);
		}

		AuthToken at = proxy.get_authToken("user", "password");

		System.out.println(sis.size()+" service(s) found\n");
		Vector siv = sis.getServiceInfoVector();
		for (int i = 0; i < siv.size(); i++) {
			ServiceInfo si = (ServiceInfo)siv.elementAt(i);
			System.out.println(si.getNameString());
			System.out.println(si.getServiceKey());
			System.out.println("\n");

			TModelBag tb = new TModelBag();
			tb.add(new TModelKey(ti.getTModelKey()));
			BindingDetail bd = proxy.find_binding(null, si.getServiceKey(), tb, 0);

			Vector bdv = bd.getBindingTemplateVector();
			if (bdv.size() == 0) {
				System.out.println("no binding(s) found");
			}
			else {
				System.out.println(bdv.size()+" binding(s) found\n");
				for (int j = 0; j < bdv.size(); j++) {
					BindingTemplate bt = (BindingTemplate)bdv.elementAt(j);
					System.out.println(bt.getDefaultDescriptionString());
					System.out.println(bt.getBindingKey());
					DispositionReport dr = proxy.delete_binding(at.getAuthInfoString(), bt.getBindingKey());
					System.out.println("binding template deleted : "+dr.success());
					System.out.println("\n");
				}
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}